<?php



/*///////////////////////////////// Register Panel Scripts and Styles /////////////////////////////////////////*/
function roofing_admin_register() {

  wp_register_script( 'wd-admin-main', get_template_directory_uri() . '/inc/js/script.js',
              array( 'jquery', 'jquery-ui-core', 'jquery-ui-widget', 'jquery-ui-mouse', 'jquery-ui-tabs',
              'jquery-ui-droppable', 'jquery-ui-sortable' ) , false , false );
  wp_register_style( 'themify-icons', get_template_directory_uri().'/inc/themify-icons.css', array(), '20120208', 'all' );
  wp_register_style( 'wd-style', get_template_directory_uri().'/inc/css/style.css', array(), '20120208', 'all' );

  $font_body_name = roofing_get_option('roofing_body_font_familly','Open Sans');
  $roofing_font_weight_style = roofing_get_option('roofing_font-weight-style','400');
  $roofing_main_text_font_subsets = roofing_get_option('roofing_main-text-font-subsets','latin');

  $font_header_name = roofing_get_option('roofing_head_font_familly','Open Sans');
  $roofing_heading_font_weight_style = roofing_get_option('roofing_heading-font-weight-style','400');
  $roofing_heading_text_font_subsets = roofing_get_option('roofing_heading-text-font-subsets','latin');

  $roofing_navigation_font_familly = roofing_get_option('roofing_navigation_font_familly', 'Open Sans');
  $roofing_navigation_font_weight_style = roofing_get_option('roofing_navigation-font-weight-style', '400');
  $roofing_navigation_text_font_subsets = roofing_get_option('roofing_navigation-text-font-subsets', 'latin');
  $protocol = is_ssl() ? 'https' : 'http';


  wp_register_style( 'wd-google-fonts-body', $protocol.'://fonts.googleapis.com/css?family=' . $font_body_name . ':' . $roofing_font_weight_style . '&subset=' . $roofing_main_text_font_subsets , false, NULL, 'all' );
  wp_register_style( 'wd-google-fonts-heading', $protocol.'://fonts.googleapis.com/css?family=' . $font_header_name . ':' . $roofing_heading_font_weight_style . '&subset=' . $roofing_heading_text_font_subsets , false, NULL, 'all' );
  wp_register_style( 'wd-google-fonts-navigation', $protocol.'://fonts.googleapis.com/css?family=' . $roofing_navigation_font_familly . ':' . $roofing_navigation_font_weight_style . '&subset=' . $roofing_navigation_text_font_subsets , false, NULL, 'all' );

  wp_register_style( 'wd-google-fonts', $protocol.'://fonts.googleapis.com/css?family=' . $font_body_name . ':' . $roofing_font_weight_style . '&subset=' . $roofing_main_text_font_subsets , false, NULL, 'all' );

  if ( isset( $_GET['page'] ) && $_GET['page'] == 'option panel' ) {


  }
  wp_enqueue_script( 'wd-admin-main' );
  wp_enqueue_style( 'themify-icons' );
  wp_enqueue_style( 'wd-style' );
  wp_enqueue_style( 'wd-google-fonts' );
  wp_enqueue_style( 'wd-google-fonts-body' );
  wp_enqueue_style( 'wd-google-fonts-heading' );
  wp_enqueue_style( 'wd-google-fonts-navigation' );

}
add_action( 'admin_enqueue_scripts', 'roofing_admin_register' );



if(!function_exists('roofing_load_color_picker')){
  add_action( 'load-widgets.php', 'roofing_load_color_picker' );
  function roofing_load_color_picker() {
      wp_enqueue_style( 'wp-color-picker' );
      wp_enqueue_script( 'wp-color-picker' );
  }
}




/*///////////////////////////////// Theme Options /////////////////////////////////////////*/
if(!function_exists('roofing_panel_option')){
  add_action('admin_menu','roofing_panel_option');
  function roofing_panel_option(){

    add_theme_support( 'custom-header' );

    add_theme_page('Roofing Options', 'Roofing Options', 'edit_theme_options', 'roofing-theme-option' , 'roofing_theme_option');
  }
}



if(!function_exists('roofing_theme_option')){
  function roofing_theme_option() {

    wp_enqueue_media();


    wp_enqueue_script('wp-color-picker');
    wp_enqueue_style( 'wp-color-picker' );


    wp_enqueue_script('colorpick',    get_template_directory_uri() . "/js/bootstrap-colorpicker.min.js", array( 'jquery' ) );
    wp_enqueue_style ('colorpick',    get_template_directory_uri() . "/stylesheets/bootstrap-colorpicker.min.css");
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        $('.wd-color-picker').colorpicker(
          {format: 'rgba'}
        );

      //---------------logo script-----------
      jQuery('#roofing_upload_btn').click(function(){
      wp.media.editor.send.attachment = function(props, attachment){
        jQuery('#roofing_logo_path').val(attachment.url);
      }
      wp.media.editor.open(this);

      return false;
      });
     
      
      //------favicon script-----
      jQuery('#roofing_upload_favicon').click(function(){
        wp.media.editor.send.attachment = function(props, attachment){
          jQuery('#roofing_favicon_icon_path').val(attachment.url);
        }
        wp.media.editor.open(this);
        return false;
      });
		//------single background post script-----
      jQuery('#roofing_upload_single_post').click(function(){
        wp.media.editor.send.attachment = function(props, attachment){
          jQuery('#roofing_bg_single_post_path').val(attachment.url);
        }
        wp.media.editor.open(this);
        return false;
      });
    //-------------------------------------

    });
    </script>
    <?php


    if(!empty($_POST)){

    	$roofing_allowed_html_array = array(
          'a' => array(
              'href' => array(),
              'title' => array()
          ),
          'br' => array(),
          'em' => array(),
          'strong' => array(),
      );
      // webdevia_initialize_options();

      // greenenergy_initialize_options();
		//-------------------General Setting-------------
		roofing_save_option('roofing_logo_path',     esc_attr($_POST['roofing_logo_path']));
		roofing_save_option('roofing_favicon_icon_path',     esc_attr($_POST['roofing_favicon_icon_path']));
		roofing_save_option('roofing_bg_single_post_path',     esc_attr($_POST['roofing_bg_single_post_path']));
		roofing_save_option('roofing_menu_style',     esc_attr($_POST['roofing_menu_style']));
		//-------------------Color Setting-------------
		roofing_save_option('roofing_primary_color',     esc_attr($_POST['roofing_primary_color']));
    roofing_save_option('roofing_nav_bg_color',     esc_attr($_POST['roofing_nav_bg_color']));
		roofing_save_option('roofing_secondary_color',     esc_attr($_POST['roofing_secondary_color']));
		
		//-------------------Social Icon-------------
		roofing_save_option('roofing_twitter', esc_attr($_POST['roofing_twitter']));
      	roofing_save_option('roofing_facebook', esc_attr($_POST['roofing_facebook']));
		roofing_save_option('roofing_google_plus', esc_attr($_POST['roofing_google_plus']));
		roofing_save_option('roofing_phone', esc_attr($_POST['roofing_phone']));
		//-------------------Fonts Setting ---------------
		
		//------------------Custom css & js ---------------
		roofing_save_option('roofing_theme_custom_css', str_replace("\\", "", $_POST['roofing_theme_custom_css']));
		roofing_save_option('roofing_theme_custom_js', str_replace("\\", "", $_POST['roofing_theme_custom_js']));
		//-------------------Footer Setting-------------

		roofing_save_option('roofing_footer_columns',     esc_attr($_POST['roofing_footer_columns']));
		roofing_save_option('roofing_copyright',     wp_kses($_POST['roofing_copyright'],$roofing_allowed_html_array));

    roofing_save_option('roofing_body_font_familly', esc_attr($_POST['roofing_body_font_familly']));
    roofing_save_option('roofing_font-weight-style', esc_attr($_POST['roofing_font-weight-style']));
    roofing_save_option('roofing_main-text-font-subsets', esc_attr($_POST['roofing_main-text-font-subsets']));
    roofing_save_option('roofing_text-transform', esc_attr($_POST['roofing_text-transform']));
    roofing_save_option('roofing_body-font-size', esc_attr($_POST['roofing_body-font-size']));


    roofing_save_option('roofing_head_font_familly', esc_attr($_POST['roofing_head_font_familly']));
    roofing_save_option('roofing_heading-font-weight-style', esc_attr($_POST['roofing_heading-font-weight-style']));
    roofing_save_option('roofing_heading-text-font-subsets', esc_attr($_POST['roofing_heading-text-font-subsets']));
    roofing_save_option('roofing_heading-transform', esc_attr($_POST['roofing_heading-transform']));

    roofing_save_option('roofing_navigation_font_familly', esc_attr($_POST['roofing_navigation_font_familly']));
    roofing_save_option('roofing_navigation-font-weight-style', esc_attr($_POST['roofing_navigation-font-weight-style']));
    roofing_save_option('roofing_navigation-text-font-subsets', esc_attr($_POST['roofing_navigation-text-font-subsets']));
    roofing_save_option('roofing_navigation-transform', esc_attr($_POST['roofing_navigation-transform']));
    roofing_save_option('roofing_navigation-font-size', esc_attr($_POST['roofing_navigation-font-size']));

      
    } ?>



  <?php if(!empty($_POST)): ?>
    <div id="message" class="updated fade">
      <p> Configuration updated!! </p>
    </div>
  <?php endif;  ?>


  <div class="panel-logo">
          <h2>Webdevia theme options</h2>
      </div>
<div class="wd-cpanel">
  <form id="wd-Panel"  method="POST" action="">
    <div id="tabs" class="ui-tabs-vertical ui-helper-clearfix">
        <ul>
          <li><a href="#tabs-0"><?php echo esc_html__('General Settings','roofing'); ?></a></li>
          <li><a href="#tabs-1"><?php echo esc_html__('Color Stetting','roofing'); ?></a></li>
          <li><a href="#tabs-2"><?php echo esc_html__('Social Icon','roofing'); ?></a></li>
          <li><a href="#tabs-3"><?php echo esc_html__('Fonts Settings','roofing'); ?></a></li>
          <li><a href="#tabs-4"><?php echo esc_html__('Custon css & js','roofing'); ?></a></li>
          <li><a href="#tabs-5"><?php echo esc_html__('Footer Setting','roofing'); ?></a></li>
          <?php if ( is_plugin_active( 'wd-main-plugin/wd-main-plugin.php' ) ) { ?>
          <li><a href="#tabs-6"><?php echo esc_html__('Import Demos','roofing'); ?></a></li>
          <?php } ?>
        </ul>
        
        <!---------------------------------- General Setting ------------------------>
        <div id="tabs-0">
          <table class="form-table">
            <tbody>
              
               <tr>
                <td>
                  <strong><?php echo esc_html__('Logo link','roofing'); ?></strong>
                </td>
                <?php 
                 $roofing_default_logo_path = get_template_directory_uri().'/images/logo-white.png';
                 $roofing_logo_path = roofing_get_option('roofing_logo_path',$roofing_default_logo_path);
                ?>  
                <td>
                  <input type="text" name="roofing_logo_path" id="roofing_logo_path" value="<?php print $roofing_logo_path ?>" />
                  <input class="button" name="_unique_name_button" id="roofing_upload_btn" value="<?php echo esc_html__('Upload','roofing') ?>" /></br>
                </td>
                <td> 
                  	<?php
                  	 if(!empty($roofing_logo_path)): ?> <img src="<?php print $roofing_logo_path; ?>" style="max-height: 70px;" /> <?php endif;
                    ?>
                </td>
              </tr>
          	
          	  <tr>
                <td>
                  <strong><?php echo esc_html__('Favicon Icon Link','roofing'); ?></strong>
                </td>
                <?php 
                 $roofing_default_favicon_icon_path = get_template_directory_uri().'/images/favicon.png';
                 $roofing_favicon_icon_path = roofing_get_option('roofing_favicon_icon_path',$roofing_default_favicon_icon_path);
                ?>  
                <td>
                  <input type="text" name="roofing_favicon_icon_path" id="roofing_favicon_icon_path" value="<?php print $roofing_favicon_icon_path ?>" />
                  <input class="button" name="_unique_name_button_favicon" id="roofing_upload_favicon" value="<?php echo esc_html__('Upload','roofing') ?>" /></br>
                </td>
                <td> 
                  	<?php
                  	 if(!empty($roofing_favicon_icon_path)): ?> <img src="<?php print $roofing_favicon_icon_path; ?>" style="max-height: 40px;" /> <?php endif;
                    ?>
                </td>
              </tr>
               <!--<tr>
                <td><strong><?php echo esc_html__('Menu style:','roofing'); ?></strong></td>
                <td>
                <?php $roofing_menu_style = roofing_get_option('roofing_menu_style','simple');
                ?>
                  <select name="roofing_menu_style">
                  	<option value="<?php echo esc_html__('simple','roofing') ?>" <?php if($roofing_menu_style == "simple") echo "selected"; ?>><?php echo esc_html__('Simple','roofing') ?></option>
                    <option value="<?php echo esc_html__('corporate','roofing') ?>" <?php if($roofing_menu_style == "corporate") echo "selected"; ?>><?php echo esc_html__('Corporate','roofing') ?></option>
                    
                  </select>
                </td> 
              </tr>-->
              <tr>
                <td>
                  <strong><?php echo esc_html__('Background Title Bar for Single Post','roofing'); ?></strong>
                </td>
                <?php 
                 
                 $roofing_bg_single_post_path = roofing_get_option('roofing_bg_single_post_path','');
                ?>  
                <td>
                  <input type="text" name="roofing_bg_single_post_path" id="roofing_bg_single_post_path" value="<?php print $roofing_bg_single_post_path ?>" />
                  <input class="button" name="_unique_name_button_single_post" id="roofing_upload_single_post" value="<?php echo esc_html__('Upload','roofing') ?>" /></br>
                </td>
                <td> 
                  	<?php
                  	 if(!empty($roofing_bg_single_post_path)): ?> <img src="<?php print $roofing_bg_single_post_path; ?>" style="max-height: 40px;" /> <?php endif;
                    ?>
                </td>
              </tr>

            </tbody>
          </table>
          
        </div>
        
        <!---------------------------------- Color Setting ------------------------>
        <div id="tabs-1">
            <table class="form-table">
              <tbody>
              	
                 <tr>
	                <td><strong><?php echo esc_html__('Primary Color:','roofing'); ?></strong></td>
	               	 <td class='wd-color-picker'><?php $roofing_primary_color = roofing_get_option('roofing_primary_color','#83CA13');
	               	 	?>
	                	<input name="roofing_primary_color" type="text" value="<?php print $roofing_primary_color; ?>" data-default-color="#83CA13">
	               	 <span class="input-group-addon"><i></i></span>
	                </td>
              	</tr>
              	
              	<tr>
	                <td><strong><?php echo esc_html__('Secondary Color:','roofing'); ?></strong></td>
	               	 <td class='wd-color-picker'><?php $roofing_secondary_color = roofing_get_option('roofing_secondary_color','#2098D1');
	               	 	?>
	                	<input name="roofing_secondary_color" type="text" value="<?php print $roofing_secondary_color; ?>" data-default-color="#2098D1">
	               	 <span class="input-group-addon"><i></i></span>
	                </td>
              	</tr>

                <tr>
                  <td><strong><?php echo esc_html__('Navigation background Color:','roofing'); ?></strong></td>
                   <td class='wd-color-picker'><?php $roofing_nav_bg_color = roofing_get_option('roofing_nav_bg_color','#83CA13');
                    ?>
                    <input name="roofing_nav_bg_color" type="text" value="<?php print $roofing_nav_bg_color; ?>" data-default-color="#83CA13">
                   <span class="input-group-addon"><i></i></span>
                  </td>
                </tr>
				
              </tbody>
            </table>
        </div>
        
        <!---------------------------------- Social Icon ------------------------>
        <div id="tabs-2">
          <table class="form-table">
            <tbody>
             	<tr>
                  <td>
                    <strong>Facebook</strong></td>
                  <td>http://facebook.com/<input type="text" name="roofing_facebook" placeholder="<?php echo esc_html__('Your Facebook page link','roofing') ?>" value="<?php echo roofing_get_option('roofing_facebook', ''); ?>"></td>
                </tr>
                <tr>
                  <td>
                    <strong>Twitter</strong></td>
                  <td>http://twitter.com/<input type="text" name="roofing_twitter" placeholder="<?php echo esc_html__('Your Twitter page link','roofing')  ?>" value="<?php echo roofing_get_option('roofing_twitter', ''); ?>"></td>
                </tr>
                <tr>
                  <td>
                    <strong>Google +</strong></td>
                  <td>http://google-plus.com/<input type="text" name="roofing_google_plus" placeholder="<?php echo esc_html__('Your Google-plus page link','roofing')  ?>" value="<?php echo roofing_get_option('roofing_google_plus', ''); ?>"></td>
                </tr>
				<tr>
                  <td>
                    <strong>Phone Number</strong></td>
                  <td><input type="text" name="roofing_phone" placeholder="<?php echo esc_html__('Your Phone Number','roofing')  ?>" value="<?php echo roofing_get_option('roofing_phone',''); ?>"></td>
                </tr>
            </tbody>
          </table>
        </div>
        
        <!---------------------------------- Fonts Settings ------------------------>
        <div id="tabs-3">
         <table class="form-table">
          <tbody>
            <tr>
              <td>
                <strong><?php echo esc_html__('Main text font','roofing'); ?></strong>
              </td>
              <td>
                <?php 
                $roofing_body_font_familly = roofing_get_option('roofing_body_font_familly' ,'Open Sans');
                $roofing_fontArray = array('Abel','Abril Fatface','Aclonica','Actor','Adamina','Aguafina Script','Aladin','Aldrich','Alice','Alike Angular','Alike','Allan','Allerta Stencil','Allerta','Amaranth','Amatic SC','Andada','Andika','Annie Use Your Telescope','Anonymous Pro','Antic','Anton','Arapey','Architects Daughter','Arimo','Artifika','Arvo','Asset','Astloch','Atomic Age','Aubrey','Bangers','Bentham','Bevan','Bigshot One','Bitter','Black Ops One','Bowlby One SC','Bowlby One','Brawler','Bubblegum Sans','Buda','Butcherman Caps','Cabin Condensed','Cabin Sketch','Cabin','Cagliostro','Calligraffitti','Candal','Cantarell','Cardo','Carme','Carter One','Caudex','Cedarville Cursive','Changa One','Cherry Cream Soda','Chewy','Chicle','Chivo','Coda Caption','Coda','Comfortaa','Coming Soon','Contrail One','Convergence','Cookie','Copse','Corben','Cousine','Coustard','Covered By Your Grace','Crafty Girls','Creepster Caps','Crimson Text','Crushed','Cuprum','Damion','Dancing Script','Dawning of a New Day','Days One','Delius Swash Caps','Delius Unicase','Delius','Devonshire','Didact Gothic','Dorsa','Dr Sugiyama','Droid Sans Mono','Droid Sans','Droid Serif','EB Garamond','Eater Caps','Expletus Sans','Fanwood Text','Federant','Federo','Fjord One','Fondamento','Fontdiner Swanky','Forum','Francois One','Gentium Basic','Gentium Book Basic','Geo','Geostar Fill','Geostar','Give You Glory','Gloria Hallelujah','Goblin One','Gochi Hand','Goudy Bookletter 1911','Gravitas One','Gruppo','Hammersmith One','Herr Von Muellerhoff','Holtwood One SC','Homemade Apple','IM Fell DW Pica SC','IM Fell DW Pica','IM Fell Double Pica SC','IM Fell Double Pica','IM Fell English SC','IM Fell English','IM Fell French Canon SC','IM Fell French Canon','IM Fell Great Primer SC','IM Fell Great Primer','Iceland','Inconsolata','Indie Flower','Irish Grover','Istok Web','Jockey One','Josefin Sans','Josefin Slab','Judson','Julee','Jura','Just Another Hand','Just Me Again Down Here','Kameron','Kelly Slab','Kenia','Knewave','Kranky','Kreon','Kristi','La Belle Aurore','Lancelot','Lato','League Script','Leckerli One','Lekton','Lemon','Limelight','Linden Hill','Lobster Two','Lobster','Lora','Love Ya Like A Sister','Loved by the King','Luckiest Guy','Maiden Orange','Mako','Marck Script','Marvel','Mate SC','Mate','Maven Pro','Meddon','MedievalSharp','Megrim','Merienda One','Merriweather','Metrophobic','Michroma','Miltonian Tattoo','Miltonian','Miss Fajardose','Miss Saint Delafield','Modern Antiqua','Molengo','Monofett','Monoton','Monsieur La Doulaise','Montez','Mountains of Christmas','Mr Bedford','Mr Dafoe','Mr De Haviland','Mrs Sheppards','Muli','Neucha','Neuton','News Cycle','Niconne','Nixie One','Nobile','Nosifer Caps','Nothing You Could Do','Nova Cut','Nova Flat','Nova Mono','Nova Oval','Nova Round','Nova Script','Nova Slim','Nova Square','Numans','Nunito','Old Standard TT','Open Sans Condensed','Open Sans','Orbitron','Oswald','Over the Rainbow','Ovo','PT Sans Caption','PT Sans Narrow','PT Sans','PT Serif Caption','PT Serif','Pacifico','Passero One','Patrick Hand','Paytone One','Permanent Marker','Petrona','Philosopher','Piedra','Pinyon Script','Play','Playfair Display','Podkova','Poller One','Poly','Pompiere','Prata','Prociono','Puritan','Quattrocento Sans','Quattrocento','Questrial','Quicksand','Radley','Raleway','Rammetto One','Rancho','Rationale','Redressed','Reenie Beanie','Ribeye Marrow','Ribeye','Righteous','Rochester','Rock Salt','Rokkitt','Rosario','Ruslan Display','Salsa','Sancreek','Sansita One','Satisfy','Schoolbell','Shadows Into Light','Shanti','Short Stack','Sigmar One','Signika Negative','Signika','Six Caps','Slackey','Smokum','Smythe','Sniglet','Snippet','Sorts Mill Goudy','Special Elite','Spinnaker','Spirax','Stardos Stencil','Sue Ellen Francisco','Sunshiney','Supermercado One','Swanky and Moo Moo','Syncopate','Tangerine','Tenor Sans','Terminal Dosis','The Girl Next Door','Tienne','Tinos','Tulpen One','Ubuntu Condensed','Ubuntu Mono','Ubuntu','Ultra','UnifrakturCook','UnifrakturMaguntia','Unkempt','Unlock','Unna','VT323','Varela Round','Varela','Vast Shadow','Vibur','Vidaloka','Volkhov','Vollkorn','Voltaire','Waiting for the Sunrise','Wallpoet','Walter Turncoat','Wire One','Yanone Kaffeesatz','Yellowtail','Yeseva One','Zeyada','Montserrat');
                ?>
                <table>
                  <tbody>
                    <tr>
                      <td>
                        <label for="roofing_body_font_familly">Font family :</label>
                      </td>
                      <td>
                        <select name="roofing_body_font_familly" id="roofing_body_font_familly" class="font_familly">
                          <option value="default">Default</option>
                          <?php foreach ( $roofing_fontArray as $pititablo){
                            $font_name=$pititablo;
                            ?>
                          <option value="<?php echo esc_attr($pititablo) ?>" <?php if(roofing_get_option('roofing_body_font_familly' ,'Open Sans')== $font_name) echo "selected='selected'" ?> ><?php echo esc_attr($pititablo) ?></option>
                         <?php } ?>
                        </select>
                      </td>
                    </tr>
                    <tr>
                      <td>
                        <label for="roofing_font-weight-style">Font weight and style :</label>
                      </td>
                      <td>
                        <select name="roofing_font-weight-style" id="roofing_font-weight-style" class="font_weight">
                          <option value="400" <?php if (roofing_get_option('roofing_font-weight-style' ,'400') == 400) {
                            echo 'selected';
                          } ?>><?php echo esc_html__('Normal 400','roofing') ?></option>
                          <option value="300" <?php if (roofing_get_option('roofing_font-weight-style' ,'300') == 300) {
                            echo 'selected';
                          } ?>><?php echo esc_html__('Light 300','roofing') ?></option>
                          <option value="600" <?php if (roofing_get_option('roofing_font-weight-style' ,'600') == 600) {
                            echo 'selected';
                          } ?>><?php echo esc_html__('Semi-bold 600','roofing') ?></option>
                          <option value="700" <?php if (roofing_get_option('roofing_font-weight-style','700') == 700) {
                            echo 'selected';
                          } ?>><?php echo esc_html__('Bold 700','roofing') ?></option>
                          <option value="800" <?php if (roofing_get_option('roofing_font-weight-style','800') == 800) {
                            echo 'selected';
                          } ?>><?php echo esc_html__('Extra-Bold 800','roofing') ?></option>
                        </select>
                      </td>
                    </tr>
                    <tr>
                      <td>
                        <label for="roofing_text-transform"><?php echo esc_html__('Text Transform','roofing') ?> :</label>
                      </td>
                      <td>
                        <select name="roofing_text-transform" id="roofing_text-transform" class="text_transform">
                          <option value="none" <?php if (roofing_get_option('roofing_text-transform', 'none') == 'none') {
                            echo 'selected';
                          } ?>><?php echo esc_html__('Normal','roofing') ?></option>
                          <option value="uppercase" <?php if (roofing_get_option('roofing_text-transform', 'none') == 'uppercase') {
                            echo 'selected';
                          } ?>><?php echo esc_html__('UPPERCASE','roofing') ?></option>
                          <option value="lowercase" <?php if (roofing_get_option('roofing_text-transform', 'none') == 'lowercase') {
                            echo 'selected';
                          } ?>><?php echo esc_html__('lowercase','roofing') ?></option>
                        </select>
                      </td>
                    </tr>
                    <tr>
                      <td>
                        <label for="roofing_body-font-size"><?php echo esc_html__('Font size','roofing') ?> :</label>
                      </td>
                      <td>
                      <?php $roofing_body_font_size = roofing_get_option('roofing_body-font-size', '14');
                        $fontsizeArray = array('12','14','13','15','16','17','18','19','20','22','24','26','28','30','32','34','36','38','40');
                      ?>
                        <select name="roofing_body-font-size" id="roofing_body-font-size" class="text_size">
                          <option value="default">Default</option>
                          <?php foreach ( $fontsizeArray as $font_size_item){
                            $font_size = $font_size_item;
                            ?>
                            <option value="<?php echo esc_attr($font_size_item) ?>" <?php if(roofing_get_option('roofing_body-font-size','14')== $font_size) echo "selected='selected'" ?> ><?php echo esc_attr($font_size_item) ?></option>
                         <?php } ?>
                        </select>
                      </td>
                    </tr>
                    <tr>
                      <td>
                        <label for="roofing_main-text-font-subsets"><?php echo esc_html__('Font subsets','roofing') ?> :</label>
                      </td>
                      <td>
                        <select id="roofing_main-text-font-subsets" name="roofing_main-text-font-subsets" class="font_subsets">
                          <option value="latin"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'latin'){
                        echo "selected";
                        } ?>>Latin</option>
                      <option value="cyrillic-ext"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'cyrillic-ext'){
                        echo "selected";
                        } ?>>Cyrillic Extended</option>
                      <option value="greek-ext"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'greek-ext'){
                        echo "selected";
                        } ?>>Greek Extended</option>
                      <option value="greek"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'greek'){
                        echo "selected";
                        } ?>>Greek</option>
                      <option value="vietnamese"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'vietnamese'){
                        echo "selected";
                        } ?>>Vietnamese</option>
                      <option value="latin-ext"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'latin-ext'){
                        echo "selected";
                        } ?>>Latin Extended</option>
                      <option value="cyrillic"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'cyrillic'){
                        echo "selected";
                        } ?>>Cyrillic</option>
                        </select>
                        <br>
                        <p class="body_font_result" style="font-family: '<?php echo roofing_get_option('roofing_body_font_familly' ,'Open Sans'); ?>'; font-weight: <?php roofing_get_option('roofing_font-weight-style','400'); ?>;">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod
                        tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
                        quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo
                        consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse
                        cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non
                        proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </td>
            </tr>
            <tr>
            <td>
              <strong><?php echo esc_html__('Heads(h1,h2,h3..) font family','roofing'); ?></strong>
            </td>
            <td>
            <table>
              <tbody>
                <tr>
                  <td>
                    <label for="roofing_head_font_familly"><?php echo esc_html__('Font family','roofing') ?> :</label>
                  </td>
                  <td>
                    <select name="roofing_head_font_familly" id="roofing_head_font_familly" class="font_familly">
                      <option value="default"><?php echo esc_html__('Default','roofing') ?></option>
                      <?php
                      $roofing_head_font_familly = roofing_get_option('roofing_head_font_familly' ,'Open Sans');
                       foreach ( $roofing_fontArray as $pititablo){
                        $font_name = $pititablo;?>

                      <option value="<?php echo esc_attr($font_name) ?>" <?php if($roofing_head_font_familly == $font_name) echo "selected='selected'" ?> ><?php echo esc_attr($font_name) ?></option>
                     <?php } ?>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label for="roofing_heading-font-weight-style"><?php echo esc_html__('Font weight and style','roofing') ?> :</label>
                  </td>
                  <td>
                    <select name="roofing_heading-font-weight-style" id="roofing_heading-font-weight-style" class="font_weight">
                      <option value="400" <?php if (roofing_get_option('roofing_heading-font-weight-style','700') == 400) {
                            echo 'selected';
                          } ?>>Normal 400</option>
                          <option value="300" <?php if (roofing_get_option('roofing_heading-font-weight-style','700') == 300) {
                            echo 'selected';
                          } ?>>Light 300</option>
                          <option value="600" <?php if (roofing_get_option('roofing_heading-font-weight-style','700') == 600) {
                            echo 'selected';
                          } ?>>Semi-bold 600</option>
                          <option value="700" <?php if (roofing_get_option('roofing_heading-font-weight-style','700') == 700) {
                            echo 'selected';
                          } ?>>Bold 700</option>
                          <option value="800" <?php if (roofing_get_option('roofing_heading-font-weight-style','700') == 800) {
                            echo 'selected';
                          } ?>>Extra-Bold 800</option>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label for="roofing_heading-transform"><?php echo esc_html__('Text Transform','roofing') ?> :</label>
                  </td>
                  <td>
                    <select name="roofing_heading-transform" id="roofing_heading-transform" class="text_transform">
                      <option value="none" <?php if (roofing_get_option('roofing_text-transform', 'none') == 'none') {
                        echo 'selected';
                      } ?>>Normal</option>
                      <option value="uppercase" <?php if (roofing_get_option('roofing_text-transform', 'none') == 'uppercase') {
                        echo 'selected';
                      } ?>>UPPERCASE</option>
                      <option value="lowercase" <?php if (roofing_get_option('roofing_text-transform', 'none') == 'lowercase') {
                        echo 'selected';
                      } ?>>lowercase</option>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label for="roofing_heading-text-font-subsets"><?php echo esc_html__('Font subsets ','roofing') ?>:</label>
                  </td>
                  <td>
                    <select id="roofing_heading-text-font-subsets" name="roofing_heading-text-font-subsets" class="font_subsets">
                      <option value="latin"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'latin'){
                        echo "selected";
                        } ?>>Latin</option>
                      <option value="cyrillic-ext"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'cyrillic-ext'){
                        echo "selected";
                        } ?>>Cyrillic Extended</option>
                      <option value="greek-ext"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'greek-ext'){
                        echo "selected";
                        } ?>>Greek Extended</option>
                      <option value="greek"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'greek'){
                        echo "selected";
                        } ?>>Greek</option>
                      <option value="vietnamese"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'vietnamese'){
                        echo "selected";
                        } ?>>Vietnamese</option>
                      <option value="latin-ext"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'latin-ext'){
                        echo "selected";
                        } ?>>Latin Extended</option>
                      <option value="cyrillic"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'cyrillic'){
                        echo "selected";
                        } ?>>Cyrillic</option>
                    </select>
                    <h2 class="heading_font_result" style="font-family: '<?php echo roofing_get_option('roofing_head_font_familly' ,'Open Sans'); ?>'; font-weight: <?php roofing_get_option('roofing_heading-font-weight-style','400'); ?>;">Lorem ipsum dolor sit amet, consectetur adipisicing elit</h2>
                  </td>
                </tr>
              </tbody>
            </table>
            </td>
          </tr>
          <tr>
            <td>
              <strong><?php echo esc_html__('Navigation font family','roofing'); ?></strong>
            </td>
            <td>
            <table>
              <tbody>
                <tr>
                  <td>
                    <label for="roofing_navigation_font_familly"><?php echo esc_html__('Font family','roofing') ?> :</label>
                  </td>
                  <td>
                    <select name="roofing_navigation_font_familly" id="roofing_navigation_font_familly" class="font_familly">
                    <option value="default">Default</option>
                      <?php
                      $roofing_navigation_font_familly = roofing_get_option('roofing_navigation_font_familly' ,'Open Sans');
                       foreach ( $roofing_fontArray as $pititablo){
                        $font_name=$pititablo;?>

                      <option value="<?php echo esc_attr($font_name) ?>" <?php if(roofing_get_option('roofing_navigation_font_familly' ,'Open Sans')== $font_name) echo "selected='selected'" ?> ><?php echo esc_attr($font_name) ?></option>
                     <?php } ?>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label for="roofing_navigation-font-weight-style"><?php echo esc_html__('Font weight and style','roofing') ?> :</label>
                  </td>
                  <td>
                    <select name="roofing_navigation-font-weight-style" id="roofing_navigation-font-weight-style" class="font_weight">
                      <option value="400" <?php if (roofing_get_option('roofing_navigation-font-weight-style','400') == 400) {
                            echo 'selected';
                          } ?>>Normal 400</option>
                          <option value="300" <?php if (roofing_get_option('roofing_navigation-font-weight-style','400') == 300) {
                            echo 'selected';
                          } ?>>Light 300</option>
                          <option value="600" <?php if (roofing_get_option('roofing_navigation-font-weight-style','400') == 600) {
                            echo 'selected';
                          } ?>>Semi-bold 600</option>
                          <option value="700" <?php if (roofing_get_option('roofing_navigation-font-weight-style','400') == 700) {
                            echo 'selected';
                          } ?>>Bold 700</option>
                          <option value="800" <?php if (roofing_get_option('roofing_navigation-font-weight-style','400') == 800) {
                            echo 'selected';
                          } ?>>Extra-Bold 800</option>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label for="roofing_navigation-transform"><?php echo esc_html__('Text Transform','roofing') ?> :</label>
                  </td>
                  <td>
                    <select name="roofing_navigation-transform" id="roofing_navigation-transform" class="text_transform">
                      <option value="none" <?php if (roofing_get_option('roofing_navigation-transform', 'none') == 'none') {
                        echo 'selected';
                      } ?>>Normal</option>
                      <option value="uppercase" <?php if (roofing_get_option('roofing_navigation-transform', 'none') == 'uppercase') {
                        echo 'selected';
                      } ?>>UPPERCASE</option>
                      <option value="lowercase" <?php if (roofing_get_option('roofing_navigation-transform', 'none') == 'lowercase') {
                        echo 'selected';
                      } ?>>lowercase</option>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label for="roofing_navigation-font-size"><?php echo esc_html__('Font size','roofing') ?> :</label>
                  </td>
                  <td>
                  <?php $roofing_body_font_size = roofing_get_option('roofing_navigation-font-size','14');
                  ?>
                    <select name="roofing_navigation-font-size" id="roofing_navigation-font-size" class="text_size">
                      <option value="default">Default</option>
                      <?php foreach ( $fontsizeArray as $font_size_item){
                        $font_size = $font_size_item;
                        ?>
                        <option value="<?php echo esc_attr($font_size_item) ?>" <?php if(roofing_get_option('roofing_navigation-font-size','14')== $font_size) echo "selected='selected'" ?> ><?php echo esc_attr($font_size_item) ?></option>
                     <?php } ?>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label for="roofing_navigation-text-font-subsets"><?php echo esc_html__('Font subsets','roofing') ?> :</label>
                  </td>
                  <td>
                    <select id="roofing_navigation-text-font-subsets" name="roofing_navigation-text-font-subsets" class="font_subsets">
                      <option value="latin"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'latin'){
                        echo "selected";
                        } ?>>Latin</option>
                      <option value="cyrillic-ext"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'cyrillic-ext'){
                        echo "selected";
                        } ?>>Cyrillic Extended</option>
                      <option value="greek-ext"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'greek-ext'){
                        echo "selected";
                        } ?>>Greek Extended</option>
                      <option value="greek"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'greek'){
                        echo "selected";
                        } ?>>Greek</option>
                      <option value="vietnamese"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'vietnamese'){
                        echo "selected";
                        } ?>>Vietnamese</option>
                      <option value="latin-ext"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'latin-ext'){
                        echo "selected";
                        } ?>>Latin Extended</option>
                      <option value="cyrillic"<?php if (roofing_get_option('roofing_navigation-text-font-subsets', 'latin') == 'cyrillic'){
                        echo "selected";
                        } ?>>Cyrillic</option>
                    </select>
                    <ul class="navigation-list" style="font-family: '<?php echo roofing_get_option('roofing_navigation_font_familly' ,'Open Sans'); ?>'; font-weight: <?php roofing_get_option('roofing_navigation-font-weight-style','400'); ?>;">
                      <li>Home</li>
                      <li>About</li>
                      <li>Services</li>
                    </ul>
                  </td>
                </tr>
              </tbody>
            </table>
            </td>
          </tr>

          </tbody>
          </table>
        </div>
       
        <!---------------------------------- Custom css & js ------------------------>
        <div id="tabs-4">
        <table class="form-table">
          <tbody>
              <tr>
                <td>
                  <strong><?php echo esc_html__('Custom css','roofing'); ?></strong>
                </td>
                <td>
                  <textarea rows="10" cols="70" name="roofing_theme_custom_css" placeholder="<?php echo esc_html__('Put your style here','roofing')  ?>"><?php echo roofing_get_option('roofing_theme_custom_css',''); ?></textarea>
                </td>
              </tr>
               <tr>
                <td>
                  <strong><?php echo esc_html__('Custom JavaScript','roofing')?></strong>
                </td>

                <td>
                  <textarea rows="10" cols="70" name="roofing_theme_custom_js" placeholder="<?php echo esc_html__('Put your JavaScript here','roofing')  ?>"><?php echo roofing_get_option('roofing_theme_custom_js',''); ?></textarea>
                </td>
              </tr>
          </tbody>
        </table>
        </div>
		<!---------------------------------- Footer Settings ------------------------>	
        <div id="tabs-5">
            <table class="form-table">
            <tbody>
             <tr>
                <td><strong><?php echo esc_html__('Footer columns','roofing'); ?></strong></td>
                <td class="roofing_footer_columns">
                   <?php $roofing_footer_columns = roofing_get_option('roofing_footer_columns','roofing_three _columns'); ?>
                    <input type="radio" id="roofing_footer1" name="roofing_footer_columns" value="one_columns" checked ="<?php if($roofing_footer_columns == 'one_columns') { echo 'checked'; }  ?>" />
                    <label for="roofing_footer1" class="roofing_footer1 <?php if($roofing_footer_columns == 'one_columns') { echo 'label_selected '; }  ?>"></label>

                    <input type="radio" id="roofing_footer2" name="roofing_footer_columns" value="tow_a_columns" checked ="<?php if($roofing_footer_columns == 'tow_a_columns') { echo 'checked'; }  ?>" />
                    <label for="roofing_footer2" class="roofing_footer2 <?php if($roofing_footer_columns == 'tow_a_columns') { echo 'label_selected '; }  ?>"></label>

                    <input type="radio" id="roofing_footer3" name="roofing_footer_columns" value="tow_b_columns" checked ="<?php if($roofing_footer_columns == 'tow_b_columns') { echo 'checked'; }  ?>" />
                    <label for="roofing_footer3" class="roofing_footer3 <?php if($roofing_footer_columns == 'tow_b_columns') { echo 'label_selected '; }  ?>"></label>

                    <input type="radio" id="roofing_footer4" name="roofing_footer_columns" value="tow_c_columns" checked ="<?php if($roofing_footer_columns == 'tow_c_columns') { echo 'checked'; }  ?>" />
                    <label for="roofing_footer4" class="roofing_footer4 <?php if($roofing_footer_columns == 'tow_c_columns') { echo 'label_selected '; }  ?>"></label>

                    <input type="radio" id="roofing_footer5" name="roofing_footer_columns" value="three_columns" checked ="<?php if($roofing_footer_columns == 'three_columns') { echo 'checked'; }  ?>" />
                    <label for="roofing_footer5" class="roofing_footer5 <?php  if($roofing_footer_columns == 'three_columns') { echo 'label_selected'; }  ?>"></label>
                </td>
              </tr>
              
               <tr>
                <td>
                  <strong><?php echo esc_html__('Footer Copyright text','roofing'); ?></strong>
                 </td>
                 <td>
                  <?php
                  $roofing_copyright = roofing_get_option('roofing_copyright','');
                  $roofing_copyright = (!empty($roofing_copyright)) ?  roofing_get_option('roofing_copyright','') : '&copy; 2015 Roofing All rights reserved.'; ?>
                  <input type="text" class="roofing_txt_big" name="roofing_copyright" placeholder="<?php echo esc_html__('Footer Copyright text','roofing')  ?>" value="<?php echo esc_attr($roofing_copyright); ?>"></td>
              </tr>
            </tbody>
            </table>
        </div>

        <!---------------------------------- Wd Importer ------------------------>
        <?php 
        if ( is_plugin_active( 'wd-main-plugin/wd-main-plugin.php' ) ) {
         ?>
        <div id="tabs-6">
        <div id="wd-metaboxes-general" class="wrap wd-page wd-page-info" style="padding: 20px;background-color: #FFF;">
             <table class="form-table">
              <tbody>
              	<tr>
                  <td style="display: none;"></td>
                  <td class="import-demo-screenshot" style="text-align: center">
                  <input type="radio" value="primary" name="demo_screenshot" id="primary">
                  <label class="primary label_selected" for="primary"></label>

                  <input type="radio" value="creative" name="demo_screenshot" id="creative">
                  <label class="creative " for="creative"></label>

                  <input type="radio" value="financial" name="demo_screenshot" id="financial">
                  <label class="financial " for="financial"></label>

                  <input type="radio" value="print" name="demo_screenshot" id="print">
                  <label class="print " for="print"></label>

                  <input type="radio" value="agency" name="demo_screenshot" id="agency">
                  <label class="agency " for="agency"></label>
                  </td>
                </tr>
                <tr>
                  <td style="display:none;">
                    
                  </td>
                  <td style="padding-left: 250px;">
                  <em class="wd-field-description">Import Type : </em>
                    <select name="import_option" id="import_option" class="form-control wd-form-element">
                      <option value=""><?php esc_html_e('Please Select', 'roofing'); ?></option>
                      <option value="<?php esc_html_e('complete_content', 'roofing'); ?>"><?php echo esc_html__('All','roofing') ?></option>
                      <option value="<?php esc_html_e('content', 'roofing'); ?>"><?php echo esc_html__('Content','roofing') ?></option>
                      <option value="<?php esc_html_e('widgets', 'roofing'); ?>"><?php echo esc_html__('Widgets','roofing') ?></option>
                      <option value="<?php esc_html_e('options', 'roofing'); ?>"><?php echo esc_html__('Options','roofing') ?></option>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td style="display: none;">
                  </td>
                  <td style="padding-left: 250px;">
                    <p><?php esc_html_e('Do you want to import media files?', 'roofing'); ?></p>
                    <input type="checkbox" value="1" class="wd-form-element" name="import_attachments" id="import_attachments" />
                  </td>
                </tr>
                <tr>
                  <td style="display: none;">
                    
                  </td>
                  <td style="padding-left: 250px;">
                  <input type="submit" class="button button-primary" value="Import" name="import" id="import_demo_data" />
                  </td>
                </tr>
                <tr>
                  <td style="display: none;">
                  </td>
                  <td style="padding-left: 250px;">
                  <span><?php esc_html_e('The import process may take some time. Please be patient.', 'roofing') ?> </span><br />
                    <div class="import_load">
                      <div class="wd-progress-bar-wrapper html5-progress-bar">
                          <div class="progress-bar-wrapper">
                              <progress id="progressbar" value="0" max="100"></progress>
                          </div>
                          <div class="progress-value">0%</div>
                          <div class="progress-bar-message">
                          </div>
                      </div>
                    </div>
                  </td>
                </tr>
                <tr>
                <td style="display: none;"></td>
                  <td style="text-align: center;">
                    <div class="alert alert-warning">
                      <strong><?php esc_html_e('Important notes:', 'roofing') ?></strong>
                      <ul>
                          <li><?php esc_html_e('Please note that import process will take time needed to download all attachments from demo web site.', 'roofing'); ?></li>
                          <li> <?php esc_html_e('If you plan to use shop, please install <b>WooCommerce</b> before you run import.', 'roofing')?></li>
                      </ul>
                    </div>
                  </td>
                </tr>
                </tbody>
              </table>
        </div>
        <script type="text/javascript">
            jQuery(document).ready(function() {
                jQuery(document).on('click', '#import_demo_data', function(e) {
                    e.preventDefault();

                    if (jQuery( "#import_option" ).val() == "") {
                      alert('Please select Import Type.');
                      return false;
                    }
                    if (confirm('Are you sure, you want to import Demo Data now?')) {
                        jQuery('.import_load').css('display','block');
                        var progressbar = jQuery('#progressbar')
                        var import_opt = jQuery( "#import_option" ).val();

                        if (jQuery(".import-demo-screenshot label.primary").hasClass("label_selected")) {
                          var import_expl = "primary";
                        }else if (jQuery(".import-demo-screenshot label.creative").hasClass("label_selected")) {
                          var import_expl = "creative";
                        }else if (jQuery(".import-demo-screenshot label.financial").hasClass("label_selected")) {
                          var import_expl = "financial";
                        }else if (jQuery(".import-demo-screenshot label.print").hasClass("label_selected")) {
                          var import_expl = "print";
                        }else if (jQuery(".import-demo-screenshot label.agency").hasClass("label_selected")) {
                          var import_expl = "agency";
                        };
                        var p = 0;
                        if(import_opt == 'content'){
                            for(var i = 1; i <= 10; i++){
                                var str;
                                if (i < 10) str = 'demo-file-0'+i+'.xml';
                                else str = 'demo-file-'+i+'.xml';
                                jQuery.ajax({
                                    type: 'POST',
                                    url: ajaxurl,
                                    data: {
                                        action: 'roofing_dataImport',
                                        xml: str,
                                        example: import_expl,
                                        import_attachments: (jQuery("#import_attachments").is(':checked') ? 1 : 0)
                                    },
                                    success: function(data, textStatus, XMLHttpRequest){
                                        console.log('Success!!' + data );
                                        p += 10;
                                        jQuery('.progress-value').html((p) + '%');
                                        progressbar.val(p);
                                        if (p == 90) {
                                            str = 'demo-file-10.xml';
                                            jQuery.ajax({
                                                type: 'POST',
                                                url: ajaxurl,
                                                data: {
                                                    action: 'roofing_dataImport',
                                                    xml: str,
                                                    example: import_expl,
                                                    import_attachments: (jQuery("#import_attachments").is(':checked') ? 1 : 0)
                                                },
                                                success: function(data, textStatus, XMLHttpRequest){
                                                    p+= 10;
                                                    jQuery('.progress-value').html((p) + '%');
                                                    progressbar.val(p);
                                                    jQuery('.progress-bar-message').html('<div class="alert alert-success"><strong>Import is completed</strong></div>');
                                                },
                                                error: function(MLHttpRequest, textStatus, errorThrown){
                                                }
                                            });
                                        }
                                    },
                                    error: function(MLHttpRequest, textStatus, errorThrown){
                                        console.log('Error!!');
                                    }
                                });
                            }
                        } else if(import_opt == 'widgets') {
                            jQuery.ajax({
                                type: 'POST',
                                url: ajaxurl,
                                data: {
                                    action: 'roofing_widgetsImport',
                                    example: import_expl
                                },
                                success: function(data, textStatus, XMLHttpRequest){
                                    console.log('widgets imported');
                                    jQuery('.progress-value').html((100) + '%');
                                    progressbar.val(100);
                                },
                                error: function(MLHttpRequest, textStatus, errorThrown){
                                }
                            });
                            jQuery('.progress-bar-message').html('<div class="alert alert-success"><strong>Import is completed</strong></div>');
                        } else if(import_opt == 'options'){
                            jQuery.ajax({
                                type: 'POST',
                                url: ajaxurl,
                                data: {
                                    action: 'roofing_import_options',
                                    example: import_expl
                                },
                                success: function(data, textStatus, XMLHttpRequest){
                                    console.log('options imported');
                                    jQuery('.progress-value').html((100) + '%');
                                    progressbar.val(100);
                                },
                                error: function(MLHttpRequest, textStatus, errorThrown){
                                }
                            });
                            jQuery('.progress-bar-message').html('<div class="alert alert-success"><strong>Import is completed</strong></div>');
                        }else if(import_opt == 'complete_content'){
                            for(var i=1;i<10;i++){
                                var str;
                                if (i < 10) str = 'demo-file-0'+i+'.xml';
                                else str = 'demo-file-'+i+'.xml';
                                jQuery.ajax({
                                    type: 'POST',
                                    url: ajaxurl,
                                    data: {
                                        action: 'roofing_dataImport',
                                        xml: str,
                                        example: import_expl,
                                        import_attachments: (jQuery("#import_attachments").is(':checked') ? 1 : 0)
                                    },
                                    success: function(data, textStatus, XMLHttpRequest){
                                        p+= 10;
                                        jQuery('.progress-value').html((p) + '%');
                                        progressbar.val(p);
                                        if (p == 90) {
                                            str = 'demo-file-10.xml';
                                            jQuery.ajax({
                                                type: 'POST',
                                                url: ajaxurl,
                                                data: {
                                                    action: 'roofing_dataImport',
                                                    xml: str,
                                                    example: import_expl,
                                                    import_attachments: (jQuery("#import_attachments").is(':checked') ? 1 : 0)
                                                },
                                                success: function(data, textStatus, XMLHttpRequest){
                                                    jQuery.ajax({
                                                        type: 'POST',
                                                        url: ajaxurl,
                                                        data: {
                                                            action: 'roofing_import_options',
                                                            example: import_expl
                                                        },
                                                        success: function(data, textStatus, XMLHttpRequest){
                                                            console.log('options imported');
                                                            jQuery.ajax({
                                                                type: 'POST',
                                                                url: ajaxurl,
                                                                data: {
                                                                    action: 'roofing_widgetsImport',
                                                                    example: import_expl
                                                                },
                                                                success: function(data, textStatus, XMLHttpRequest){

                                                                    str = 'menus.xml';
                                                                    jQuery.ajax({
                                                                        type: 'POST',
                                                                        url: ajaxurl,
                                                                        data: {
                                                                            action: 'roofing_menuImport',
                                                                            xml: str,
                                                                            example: import_expl,
                                                                            import_attachments: (jQuery("#import_attachments").is(':checked') ? 1 : 0)
                                                                        },
                                                                        success: function(data, textStatus, XMLHttpRequest){
                                                                            console.log("menu imported");
                                                                            jQuery.ajax({
                                                                                type: 'POST',
                                                                                url: ajaxurl,
                                                                                data: {
                                                                                    action: 'roofing_otherImport',
                                                                                    example: import_expl
                                                                                },
                                                                                success: function(data, textStatus, XMLHttpRequest){
                                                                                    jQuery('.progress-value').html((100) + '%');
                                                                                    progressbar.val(100);
                                                                                    jQuery('.progress-bar-message').html('<div class="alert alert-success">Import is completed.</div>');
                                                                                },
                                                                                error: function(MLHttpRequest, textStatus, errorThrown){
                                                                                }
                                                                            });
                                                                        },
                                                                        error: function(MLHttpRequest, textStatus, errorThrown){
                                                                        }
                                                                    });

                                                                },
                                                                error: function(MLHttpRequest, textStatus, errorThrown){
                                                                }
                                                            });
                                                        },
                                                        error: function(MLHttpRequest, textStatus, errorThrown){
                                                        }
                                                    });
                                                },
                                                error: function(MLHttpRequest, textStatus, errorThrown){
                                                }
                                            });
                                        }
                                    },
                                    error: function(MLHttpRequest, textStatus, errorThrown){
                                    }
                                });
                            }




                        }
                    }
                    return false;
                });
            });
        </script>

        </div>
		<?php } ?>
      
      </div>
      </div>
      <div class="eight columns wp-core-ui wd-validate"> <p><button  type="submit" name="search" value="<?php esc_html_e('Update Options', 'roofing'); ?>"
        class="button" /><span class="ti-save"></span><?php esc_html_e('Update Options', 'roofing'); ?></button></p></div>
    </form>
  </div>


  <div style="clear: both;">
    <br/><br/><br/><br/><br/><br/>
  </div>


  <div class="wb-item">
    <div class="icon-themes">

    </div>
  </div>
  <?php
  }
}