<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'twentyten' ), max( $paged, $page ) );

	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo('template_url'); ?>/chimod_custom.css" />
<!--[If IE]> 
	<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo('template_url'); ?>/ie.css" />	
<![endif]-->
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>

<script type="text/javascript">
<!--

function validate_form (form1)
{
    valid = true;


 	var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
   	var thisEmail = document.estimate_form.email.value;
	var thisTest = document.estimate_form.test.value;
		
	if ( document.estimate_form.email.value == "E-Mail*" ){ valid = false; }
	if ( document.estimate_form.email.value == "" ){ valid = false; }
	if ( document.estimate_form.test.value == "?" ){ valid = false; }
	if ( document.estimate_form.test.value == "" ){ valid = false; }
	if ( document.estimate_form.phone.value == "Phone*" ){ valid = false; }
	if ( document.estimate_form.phone.value == "" ){ valid = false; }
	
	if (valid == false){
		window.alert ( "Please fill out the required fields." )
	}
	if (valid == true){
		if(reg.test(thisEmail) == false) {
		  window.alert('Invalid Email Address');
		  valid = false;
		  }
		  
	}
    return valid;

}

function validate_form2 (form2)
{
    valid = true;
	valid1 = true;
	valid2 = true;


 	var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
   	var thisEmail = document.estimate_form2.email.value;
	var thisTest = document.estimate_form2.test.value;
		
	if ( document.estimate_form2.email.value == "" ){ valid1 = false; }
	if ( document.estimate_form2.name.value == "" ){ valid1 = false; }
	if ( document.estimate_form2.phone.value == "" ){ valid1 = false; }
	if ( document.estimate_form2.test.value == "" ){ valid1 = false; }
	if ( document.estimate_form2.test.value == "?*" ){ valid1 = false; }
	if ( document.estimate_form2.budget.selectedIndex == 0 ){ valid1 = false; }
	if ( document.estimate_form2.time.selectedIndex == 0 ){ valid1 = false; }
	if ( document.estimate_form2.howhear.selectedIndex == 0 ){ valid1 = false; }

	if (!document.estimate_form2.level[0].checked &&
		!document.estimate_form2.level[1].checked &&
		!document.estimate_form2.level[2].checked) {
			valid2 = false;
	  
	} 

	if (!document.estimate_form2.project[0].checked &&
		!document.estimate_form2.project[1].checked &&
		!document.estimate_form2.project[2].checked &&
		!document.estimate_form2.project[3].checked) {
			valid3 = false;
	  
	} 
	
	if (valid1 == false){
		window.alert ( "Please fill out the required fields." );
		valid = false;
	}
	if (valid2 == false){
		window.alert ( "Please choose from Building Sphere." );
		valid = false;
	}
	if (valid3 == false){
		window.alert ( "Please choose from Project Type." );
		valid = false;
	}
	
	if (valid == false){
		
	}
	
	if (valid == true){
		if(reg.test(thisEmail) == false) {
		  window.alert('Invalid Email Address');
		  valid1 = false;
		  }
		  
	}
    return valid;

}



function selectText(textField) 
  {
    textField.focus();
    textField.select();
  }
//-->
</script>

</head>

<body <?php body_class(); ?>>
<div id="wrapper" class="hfeed">
	<div id="header">
		<div id="masthead">
			<div id="branding" role="banner">
				
			
			
			<div id="access" role="navigation">
			  <?php /* Allow screen readers / text browsers to skip the navigation menu and get right to the good stuff */ ?>
				<div class="skip-link screen-reader-text"><a href="#content" title="<?php esc_attr_e( 'Skip to content', 'twentyten' ); ?>"><?php _e( 'Skip to content', 'twentyten' ); ?></a></div>
				<?php /* Our navigation menu. If one isn't filled out, wp_nav_menu falls back to wp_page_menu. The menu assiged to the primary position is the one used. If none is assigned, the menu with the lowest ID is used. */ ?>
				<?php wp_nav_menu( array( 'container_class' => 'menu-header', 'theme_location' => 'primary' ) ); ?>
			</div><!-- #access -->
            
            
            <div id="menu2">
            	<div id="logo">
                	<a href="<?php echo get_option('home'); ?>/" title="Home"> <img src="<?php bloginfo('template_url'); ?>/images/chicagoland_remodeling_logo.jpg" title="Chicagoland Remodeling Logo" width="295" height="79" /></a>
                </div>
                <div id="callus">
                	<a href="tel:5551234567">CALL US at (708) 583-9904</a>
                </div>
                
                <div id="access2">
                <?php /* Allow screen readers / text browsers to skip the navigation menu and get right to the good stuff */ ?>
				<div class="skip-link screen-reader-text"><a href="#content" title="<?php esc_attr_e( 'Skip to content', 'twentyten' ); ?>"><?php _e( 'Skip to content', 'twentyten' ); ?></a></div>
				<?php /* Our navigation menu. If one isn't filled out, wp_nav_menu falls back to wp_page_menu. The menu assiged to the primary position is the one used. If none is assigned, the menu with the lowest ID is used. */ ?>
                <?php wp_nav_menu( array( 'menu' => 'secondary', 'container_class' => 'menu-header' ) ); ?>
                </div>
            </div><!-- #access2 -->
		</div><!-- #menu2 -->
	</div><!-- #masthead -->
    </div><!-- #header -->

	<div id="main">
    
            <?php if ( is_page_template('page_home.php') ) : ?>   
                <div style="width:908px; height:288px;">
                    <?php if ( function_exists( 'meteor_slideshow' ) ) { meteor_slideshow(); } ?>
                </div>
            <?php elseif( is_page_template('page_roofing.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                    <img src="<?php bloginfo('template_url'); ?>/images/roofing_home.jpg" width="613" height="218" alt="Roofing" />
                </div>
			<?php elseif( is_page_template('page_kitchen.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                <img src="<?php bloginfo('template_url'); ?>/images/kitchen_home.jpg" width="613" height="218" alt="Kitchen Remodeling" />
                </div>
			<?php elseif( is_page_template('page_bathroom.php') ) : ?>
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                <img src="<?php bloginfo('template_url'); ?>/images/bathroom_home.jpg" width="613" height="218" alt="Bathroom Remodeling" />
                </div>
            <?php elseif( is_page_template('page_siding.php') ) : ?> 
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/siding_home.jpg" width="613" height="218" alt="Siding and Windows" />
                </div>
            <?php elseif( is_page_template('page_decking.php') ) : ?> 
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/decking_home.jpg" width="613" height="218" alt="Decks and Porches" />
                </div>
            <?php elseif( is_page_template('page_services.php') ) : ?> 
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/services_home.jpg" width="613" height="218" alt="Services" />
                </div>
            <?php elseif( is_page_template('page_estimate.php') ) : ?> 
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/freeEstimate.jpg" width="613" height="218" alt="Free Estimate" />
                </div>
            <?php elseif( is_page(32) ) : ?> 
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/aboutChicagolandRemodeling.jpg" width="613" height="218" alt="About Us" />
                </div>
            <?php elseif( is_page(40) ) : ?> 
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/testimonials.jpg" width="613" height="218" alt="Testimonials" />
                </div>
            <?php elseif( is_page(44) ) : ?> 
                <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/contactUs.jpg" width="613" height="218" alt="Contact Us" />
                </div>
                
                
            
            <?php elseif( is_single( /* array ( 231,233,234,239,241,243,246,250,252,254,260,264 ) */ )) : ?>
                <div style="width:908px; height:257px;">
                    <div id="head_img">
                    
                    <?php if ( has_post_thumbnail() ) {
					the_post_thumbnail('large');
                    echo get_post(get_post_thumbnail_id())->post_excerpt;
					} else { ?>
					<img src="<?php bloginfo('template_url'); ?>/images/default_home.jpg" width="613" height="218" alt="Chicago Remodeling" />
					<?php } ?>
                    
                    
                    
                    
                </div>
                
            <?php elseif( is_single() && in_category( array( 'roofing', 'kitchen', 'decking', 'siding', 'bathroom' ))  && has_post_thumbnail()  ) : ?>
                <div style="width:908px; height:257px;">
                    <div id="head_img">
                    <?php the_post_thumbnail('large');
                    echo get_post(get_post_thumbnail_id())->post_excerpt; ?>
                </div>
            
			<?php else : ?>
            	 <div style="width:908px; height:216px; margin-bottom:20px;">
                    <div id="head_img">
                   <img src="<?php bloginfo('template_url'); ?>/images/default_home.jpg" width="613" height="218" alt="Chicago Remodeling" />
                </div>
            
            
            <?php endif ?>
            
              
 		<?php if ( is_page_template('page_home.php') ) : ?>              
                
		<?php else : ?>
        	
            <div id="estimate_form_head">
                <h2 style="font-weight:bold; margin-bottom:4px;">FREE ESTIMATE</h2>
                   <form id="form1" name="estimate_form" method="post" onsubmit="return validate_form()" action="http://www.mychicagolandremodeling.com/check/contact_01.php"  >
                       <input class="head_form" name="fname" type="text"  value="Name*" onClick="this.select()" /><br />
                       <input class="head_form" name="email" id="email" type="text"  value="E-Mail*" onClick="this.select()"/><br />
                       <input class="head_form" name="phone" type="text"  value="Phone*" onClick="this.select()"/><br />
                       <textarea class="head_form message" name="message" onClick="this.select()"> Enter your comments here.</textarea><br />
                       <p>What is the sum of two plus three?*<br />
                       <input  class="head_form"  name="test" id="test" type="text" size="5" value="?" maxlength="1" onClick="this.select()" style="width:30px; text-align:center; margin-right:10px;"/>
                       <input type="submit" value="Submit" style="width:70px; font-weight:bold;" />
                       <a href="<?php echo site_url('/free-estimates/')?>" title="More options" ><img src="<?php bloginfo('template_url'); ?>/images/options_btn.jpg" width="109" height="16" alt="" style="padding-top:5px;"  /></a></p>
                   </form>   
                </div>
            </div>
    
        <?php endif ?>
            
